﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace BMS.Web.Models
{
    /// <summary>
    /// Contains all the properties used to display the page NewEvent. 
    /// </summary>
    public class NewEventViewModel : BaseViewModel
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the signed admission orders.
        /// </summary>
        /// <value>
        /// The signed admission.
        /// </value>
        public string SignedAdmissionOrders { get; set; }

        /// <summary>
        /// Gets or sets the display report signed admission. If there are signed admission orders "ShowReport" link is visible else "ShowReport" is invisible.
        /// </summary>
        /// <value>
        /// The display report signed admission.
        /// </value>
        public string DisplayReportSignedAdmissions { get; set; }

        /// <summary>
        /// Gets or sets the URL for signed admission report.
        /// </summary>
        /// <value>
        /// The signed admission URL.
        /// </value>
        public string SignedAdmissionUrl { get; set; }

        /// <summary>
        /// Gets or sets the admitted patients.
        /// </summary>
        /// <value>
        /// The admitted patients.
        /// </value>
        public string AdmittedPatients { get; set; }

        /// <summary>
        /// Gets or sets the display report admitted patients. If there are admitted patients "ShowReport" link is visible else "ShowReport" is invisible.
        /// </summary>
        /// <value>
        /// The display report admitted patients.
        /// </value>
        public string DisplayReportAdmittedPatients { get; set; }

        /// <summary>
        /// Gets or sets the URL for admitted patients report.
        /// </summary>
        /// <value>
        /// The admitted patients URL.
        /// </value>
        public string AdmittedPatientsUrl { get; set; }

        /// <summary>
        /// Gets or sets the signed transfer.
        /// </summary>
        /// <value>
        /// The signed transfer.
        /// </value>
        public string SignedTransfer { get; set; }

        /// <summary>
        /// Gets or sets the display report signed transfer. If there are signed transfer orders "ShowReport" link is visible else "ShowReport" is invisible.
        /// </summary>
        /// <value>
        /// The display report signed transfer.
        /// </value>
        public string DisplayReportSignedTransfer { get; set; }

        /// <summary>
        /// Gets or sets the Url for signed transfer report.
        /// </summary>
        /// <value>
        /// The signed transfer URL.
        /// </value>
        public string SignedTransferUrl { get; set; }
        /// <summary>
        /// Gets or sets the signed discharge.
        /// </summary>
        /// <value>
        /// The signed discharge.
        /// </value>
        public string SignedDischarge { get; set; }

        /// <summary>
        /// Gets or sets the display report signed discharge. If there are signed discharg orders "ShowReport" link is visible else "ShowReport" is invisible.
        /// </summary>
        /// <value>
        /// The display report signed discharge.
        /// </value>
        public string DisplayReportSignedDischarge { get; set; }

        /// <summary>
        /// Gets or sets the Url signed discharge report.
        /// </summary>
        /// <value>
        /// The signed discharge URL.
        /// </value>
        public string SignedDischargeUrl { get; set; }
        /// <summary>
        /// Gets or sets the signed anticipated discharge.
        /// </summary>
        /// <value>
        /// The signed anticipated discharge.
        /// </value>
        public string SignedAnticipatedDischarge { get; set; }

        /// <summary>
        /// Gets or sets the display report signed anticipated discharge. If there are signed anticipated discharge orders "ShowReport" link is visible else "ShowReport" is invisible.
        /// </summary>
        /// <value>
        /// The display report signed anticipated discharge.
        /// </value>
        public string DisplayReportSignedAnticipatedDischarge { get; set; }

        /// <summary>
        /// Gets or sets the Url signed anticipated discharge report.
        /// </summary>
        /// <value>
        /// The signed anticipated discharge URL.
        /// </value>
        public string SignedAnticipatedDischargeUrl { get; set; }
        /// <summary>
        /// Gets or sets the discharge appointments.
        /// </summary>
        /// <value>
        /// The discharge appointment.
        /// </value>
        public string DischargeAppointments { get; set; }

        /// <summary>
        /// Gets or sets the display report discharge appointment.
        /// </summary>
        /// <value>
        /// The display report discharge appointment.
        /// </value>
        public string DisplayReportDischargeAppointment { get; set; }

        /// <summary>
        /// Gets or sets the discharge appointment report Url .
        /// </summary>
        /// <value>
        /// The discharge appointment report url.
        /// </value>
        public string DischargeAppointmentUrl { get; set; }
        /// <summary>
        /// Gets or sets the patient discharged.
        /// </summary>
        /// <value>
        /// The patient discharged.
        /// </value>
        public string PatientDischarged { get; set; }

        /// <summary>
        /// Gets or sets the display report patient discharged.
        /// </summary>
        /// <value>
        /// The display report patient discharged.
        /// </value>
        public string DisplayReportPatientDischarged { get; set; }

        /// <summary>
        /// Gets or sets the patient discharged report Url.
        /// </summary>
        /// <value>
        /// The patient discharged report URL.
        /// </value>
        public string PatientDischargedUrl { get; set; }
        /// <summary>
        /// Gets or sets the vacated beds.
        /// </summary>
        /// <value>
        /// The vacated beds.
        /// </value>
        public string VacatedBeds { get; set; }

        /// <summary>
        /// Gets or sets the display report vacated beds.
        /// </summary>
        /// <value>
        /// The display report vacated beds.
        /// </value>
        public string DisplayReportVacatedBeds { get; set; }

        /// <summary>
        /// Gets or sets the vacated beds report Url.
        /// </summary>
        /// <value>
        /// The vacated beds report URL.
        /// </value>
        public string VacatedBedsUrl { get; set; }
        /// <summary>
        /// Gets or sets the currently cleaning beds.
        /// </summary>
        /// <value>
        /// The currently cleaning beds.
        /// </value>
        public string CurrentlyCleaningBeds { get; set; }

        /// <summary>
        /// Gets or sets the display report currently cleaning beds.
        /// </summary>
        /// <value>
        /// The display report currently cleaning beds.
        /// </value>
        public string DisplayReportCurrentlyCleaningBeds { get; set; }

        /// <summary>
        /// Gets or sets the Url for currently cleaning beds report.
        /// </summary>
        /// <value>
        /// The currently cleaning beds report URL.
        /// </value>
        public string CurrentlyCleaningBedsUrl { get; set; }
        /// <summary>
        /// Gets or sets the completed cleaning beds.
        /// </summary>
        /// <value>
        /// The completed cleaning beds.
        /// </value>
        public string CompletedCleaningBeds { get; set; }

        /// <summary>
        /// Gets or sets the display report completed cleaning beds.
        /// </summary>
        /// <value>
        /// The display report completed cleaning beds.
        /// </value>
        public string DisplayReportCompletedCleaningBeds { get; set; }

        /// <summary>
        /// Gets or sets the Url for completed cleaning beds report.
        /// </summary>
        /// <value>
        /// The completed cleaning beds report URL.
        /// </value>
        public string CompletedCleaningBedsUrl { get; set; }
        /// <summary>
        /// Gets or sets the beds out of service.
        /// </summary>
        /// <value>
        /// The beds out of service.
        /// </value>
        public string BedsOutOfService { get; set; }

        /// <summary>
        /// Gets or sets the display report beds out of service.
        /// </summary>
        /// <value>
        /// The display report beds out of service.
        /// </value>
        public string DisplayReportBedsOutOfService { get; set; }

        /// <summary>
        /// Gets or sets the Url for bed out of service report.
        /// </summary>
        /// <value>
        /// The bed out of service report URL.
        /// </value>
        public string BedOutOfServiceUrl { get; set; }
        /// <summary>
        /// Gets or sets the view report.
        /// </summary>
        /// <value>
        /// The view report.
        /// </value>
        public string ViewReport { get; set; }

        /// <summary>
        /// Gets or sets the back to service.
        /// </summary>
        /// <value>
        /// The back to service.
        /// </value>
        public string BackToService { get; set; }

        /// <summary>
        /// Gets or sets the display report back to service.
        /// </summary>
        /// <value>
        /// The display report back to service.
        /// </value>
        public string DisplayReportBackToService { get; set; }

        /// <summary>
        /// Gets or sets the Url for back to service report.
        /// </summary>
        /// <value>
        /// The back to service report URL.
        /// </value>
        public string BackToServiceUrl { get; set; }

        /// <summary>
        /// Gets or sets the div EMS active display.
        /// </summary>
        /// <value>
        /// The div EMS active display.
        /// </value>
        public string DivEMSActiveDisplay { get; set; }

        /// <summary>
        /// Gets or sets the div EMS inactive display.
        /// </summary>
        /// <value>
        /// The div EMS inactive display.
        /// </value>
        public string DivEMSInactiveDisplay { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        /// <value>
        /// The start date.
        /// </value>
        public DateTime StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        /// <value>
        /// The end date.
        /// </value>
        public DateTime EndDate { get; set; }

        /// <summary>
        /// Gets or sets the return URL.
        /// </summary>
        /// <value>
        /// The return URL.
        /// </value>
        public string ReturnUrl { get; set; }

        #endregion
    }
}